// VERSION: Scilab: 5.4.1 
// OS: windows 7 
//CAPTION: PROGRAM TO COMPUTE BLOCK CONVOLUTION USING OVERLAP ADD METHOD
clc;
clear;
close;
x=input('Enter the input sequence=') //x=[1 2 -1 2 3 -2 -3 -1 1 1 2 -1]
m=length(x);
xl=input('Enter the lower index of input sequence=')//0
xh=xl+m-1;
n=xl:1:xh;
subplot(3,1,1);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',n,x);
title('Input Sequence x[n]');
xlabel('Samples n');
ylabel('Amplitude');

h=input('Enter the impulse response sequence=');//h=[1 2 3 -1]
l=length(h);
hl=input('Enter the lower index of impulse response sequence=');//0
hh=hl+l-1;
g=hl:1:hh;
subplot(3,1,2);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',g,h);
title('Impulse Response Sequence h[n]');
xlabel('Samples n');
ylabel('Amplitude');

N=m+l-1;
h1=[h zeros(1,l-1)];
n3=length(h1);
y=zeros(1,N);

H=fft(h1);
for i=1:l:m
    if i<=(m+l-1) then
        x1=[x(i:i+n3-l) zeros(1,n3-l)];
    else
        x1=[x(i:m) zeros(1,n3-l)];
    end
    x2=fft(x1);
    x3=x2.*H;
    x4=round(ifft(x3));
    if(i==1)
    y(1:n3)=x4(1:n3);
else
    y(i:i+n3-1)=y(i:i+n3-1)+x4(1:n3);
end
end
   
disp('Output sequence using Overlap add method y(n):');
disp(y(1:N));
nx=xl+hl;
r=nx:length(y)-1;
subplot(3,1,3);
a=gca();
a.x_location="origin";
a.y_location="origin";
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
plot2d3('gnn',r,y);
title('Output sequence using Overlap add method y[n]');
xlabel('Samples n');
ylabel('Amplitude');

//INPUT:
//Enter the input sequence=[1 2 -1 2 3 -2 -3 -1 1 1 2 -1]
//Enter the lower index of input sequence=0
//Enter the impulse response sequence=[1 2 3 -1]
//Enter the lower index of impulse response sequence=0
 
 //OUTPUT:
 //Output sequence using Overlap add method y(n):   
 
 
   //      column  1 to 12
 
   // 1.    4.    6.    5.    2.    11.    0.  - 16.  - 8.    3.    8.    5.  
 
 //        column 13 to 15
 
   // 3.  - 5.    1.  
